var darkMode = window.matchMedia('(prefers-color-scheme: dark)').matches || false,
appleTouch = document.getElementById('bh-apple-touch-icon'),
favicon32 = document.getElementById('bh-favicon-32'),
favicon16 = document.getElementById('bh-favicon-16'),
favicon = document.getElementById('bh-favicon'),
manifest = document.getElementById('bh-manifest'),
safariPinnedTab = document.getElementById('bh-safari-pinned-tab'),
isIE11 = !!window.MSInputMethodContext && !!document.documentMode,
isEdge = window.navigator.userAgent.indexOf("Edge") > -1;

function switchIcons(darkMode) {
    if (darkMode) { 
        appleTouch.href = appleTouch.href.split('.png')[0] + '-white.png';
        favicon32.href = favicon32.href.split('.png')[0] + '-white.png';
        favicon16.href = favicon16.href.split('.png')[0] + '-white.png';
        favicon.href = favicon.href.split('.png')[0] + '-white.png';
        manifest.href = manifest.href.split('.webmanifest')[0] + '-white.webmanifest';
        safariPinnedTab.setAttribute('color', '#ffffff');
    } else {
        appleTouch.href = appleTouch.href.split('-white.png')[0] + '.png';
        favicon32.href = favicon32.href.split('-white.png')[0] + '.png';
        favicon16.href = favicon16.href.split('-white.png')[0] + '.png';
        favicon.href = favicon.href.split('-white.png')[0] + '.png';
        manifest.href = manifest.href.split('-white.webmanifest')[0] + '.webmanifest';
        safariPinnedTab.setAttribute('color', '#00205b');
    }
}

if (!isIE11 && !isEdge) {
    window.matchMedia('(prefers-color-scheme: dark)').addEventListener('change', function (e) { switchIcons(e.matches) });
}

if (darkMode) { 
    switchIcons(darkMode);
}